function [ang,ang1,isGroove] = GetGrooves(r1,r3,x_spiral,y_spiral,n_grooves,beta,delta_beta,R,Theta)
isGroove = false(size(R));
Theta = Theta - pi;

%% Logarithmic groove geometry
passo = 2.*pi.*r3./n_grooves;
deltateta = passo./r3;
a2 = passo./(1+x_spiral);
a1 = passo-a2;
b = y_spiral.*(r3-r1);
r2 = r3-b;
% beta = beta/180*pi;

R_logic = R(1,R(1,:)>=r2);
pos = find(R(1,:)==R_logic(1));

r=linspace(r2,r3,length(R_logic));
angle=-tan(beta).*log(r./r3)-delta_beta;
angle1=angle+a1./r3;

% [~,pos] = min(abs(R(1,:)-r2));
% pos = find(R(1,:)==r2);
angle_logic = -tan(beta).*log(R_logic./r3)-delta_beta;
angle1_logic = angle_logic + a1/r3;

%% Groove identification
ang = zeros(length(angle),n_grooves);
ang1 = zeros(length(angle1),n_grooves);
angle_logic = angle_logic - deltateta;
angle1_logic = angle1_logic - deltateta;

for i=1:n_grooves
    ang(:,i) = angle+(i-1).*deltateta;
    ang1(:,i) = angle1+(i-1).*deltateta;
    angle_logic = angle_logic + deltateta;
    angle1_logic = angle1_logic + deltateta;

    angle_logic(angle_logic>pi) = angle_logic(angle_logic>pi) - 2*pi;
    angle1_logic(angle1_logic>pi) = angle1_logic(angle1_logic>pi) - 2*pi;
    pos_log = angle_logic>0 & angle1_logic<0;
    if ~isempty(find(pos_log,1))
    pos_log = find(pos_log);
    Theta_log = [false(size(Theta,1),pos-1) Theta(:,pos:end)>angle_logic&Theta(:,pos:end)<angle1_logic];
    % Theta_log = Theta_log | [false(size(Theta,1),a_log(1)-1) Theta(:,a_log)];
    Theta_log = Theta_log | [false(size(Theta,1),pos+pos_log(1)-2) ...
        Theta(:,pos_log)>angle_logic(pos_log)|Theta(:,pos_log)<angle1_logic(pos_log)...
        false(size(Theta,1),size(Theta,2)-pos_log(end)-pos+1)];

    else

    Theta_log = [false(size(Theta,1),pos-1) Theta(:,pos:end)>angle_logic&Theta(:,pos:end)<angle1_logic];

    end
    isGroove = isGroove | Theta_log;
    isGroove = isGroove & R>=r2;
end


end